<?php
namespace greenweb\core\download;

use greenweb\core\base\Download;

class FtpDownload extends Download
{
    public $ftpFile;

    public $ftpServer;

    public $ftpUsername;

    public $ftpPassword;

    public function download()
    {
        try {
            $get = false;
            $fp = ftp_connect($this->ftpServer);
            if($fp and ftp_login($fp, $this->ftpUsername, $this->ftpPassword)) {
                $get = ftp_get($fp, $this->fileName, $this->ftpFile, FTP_BINARY);
                ftp_close($fp);
            }
            return $get;
        } catch (\Exception $ex) {
            return false;
        }
    }

    public function remoteFileName()
    {
        return $this->ftpFile;
    }
}