<?php
namespace greenweb\core\browser;

use greenweb\core\App;
use greenweb\core\base\PrimaryObject;

/**
 * Class Response
 * @package greenweb\core\browser
 *
 * @property $url
 * @property $content_type
 * @property $http_code
 * @property $header_size
 * @property $request_size
 * @property $filetime
 * @property $ssl_verify_result
 * @property $redirect_count
 * @property $total_time
 * @property $namelookup_time
 * @property $connect_time
 * @property $pretransfer_time
 * @property $size_upload
 * @property $size_download
 * @property $speed_download
 * @property $speed_upload
 * @property $download_content_length
 * @property $upload_content_length
 * @property $starttransfer_time
 * @property $redirect_time
 * @property $redirect_url
 * @property $primary_ip
 * @property $certinfo
 * @property $primary_port
 * @property $local_ip
 * @property $local_port
 */
class Response extends PrimaryObject
{
    public $headers = [];

    public $body;

    public function setResponse($response, array $info = [])
    {
        App::configure($this, $info);
        $this->body = substr($response, $this->header_size);

        $headers = trim(substr($response, 0, $this->header_size));
        foreach (explode(PHP_EOL, $headers) as $header) {
            if (($p = strpos($header, ':')) !== false) {
                $this->headers[substr($header, 0, $p)] = trim(substr($header, $p + 1));
            }
            else {
                $this->headers[] = trim($header);
            }
        }
    }
}