<?php
namespace greenweb\core\base;

use phpooya\gdfarsitext\Bidi;

abstract class Transliteration extends PrimaryObject
{
    const MAP_ALL = 3;
    const MAP_CHARACTERS = 0;
    const MAP_NUMBERS = 1;
    const MAP_WORDS = 2;

    public $mapNumbers = [];

    public $mapCharacters = [];

    public $mapWords = [];

    abstract public function isValid($text);

    public function standardization($text, array $options = [self::MAP_ALL])
    {
        if (in_array(self::MAP_ALL, $options)) {
            return $this->mapNumbers($this->mapCharacters($this->mapWords($text)));
        }
        if (in_array(self::MAP_NUMBERS, $options)) {
            $text = $this->mapNumbers($text);
        }
        if (in_array(self::MAP_CHARACTERS, $options)) {
            $text = $this->mapCharacters($text);
        }
        if (in_array(self::MAP_WORDS, $options)) {
            $text = $this->mapWords($text);
        }
        return $text;
    }

    private function mapNumbers($text)
    {
        $bidi = new Bidi();
        foreach ($this->mapNumbers as $to => $from) {
            foreach ($from as $i => $chr) {
                $from[$i] = $bidi->unichr($chr);
            }
            $text = str_replace($from, $bidi->unichr($to), $text);
        }
        return $text;
    }

    private function mapCharacters($text)
    {
        $bidi = new Bidi();
        foreach ($this->mapCharacters as $to => $from) {
            foreach ($from as $i => $chr) {
                $from[$i] = $bidi->unichr($chr);
            }
            $text = str_replace($from, $bidi->unichr($to), $text);
        }
        return $text;
    }

    private function mapWords($text)
    {
        return $text;
    }
}