<?php
namespace greenweb\core\base;

class Session extends Component implements \ArrayAccess
{
    public function init()
    {
        parent::init();
        $this->start();
    }

    public function start()
    {
        if(session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function offsetExists($offset)
    {
        return isset($_SESSION[$offset]);
    }

    public function offsetGet($offset)
    {
        return $_SESSION[$offset];
    }

    public function offsetSet($offset, $value)
    {
        $_SESSION[$offset] = $value;
    }

    public function offsetUnset($offset)
    {
        unset($_SESSION[$offset]);
    }
}