<?php
namespace greenweb\core\base;

use greenweb\core\App;
use greenweb\core\exceptions\RouteNotFoundException;

class Router extends Component
{
    public $controllersNamespace = 'app\controllers';

    public $defaultRoute = 'site/index';

    public $errorAction;

    public function init()
    {
        parent::init();
        $this->app->on(App::EVENT_INIT, [$this, 'route']);
    }

    public function route()
    {
        $req = $this->app->request;
        $uri = ltrim($req->uri(), '/');
        @ list($controller, $action) = explode('/', $uri);

        if (empty($controller)) {
            list($controller, $action) = explode('/', $this->defaultRoute);
        }
        elseif (empty($action)) {
            list( , $action) = explode('/', $this->defaultRoute);
        }

        $controller = $this->controllersNamespace . '\\' . ucfirst($controller);
        $action = 'action' . ucfirst($action);

        if (class_exists($controller, false)) {
            $obj = new $controller();
            return $obj->{$action}();
        }
        elseif ($this->errorAction) {
            list($controller, $action) = explode('/', $this->errorAction);
            $obj = new $controller();
            return $obj->{$action}();
        }
        else {
            throw new RouteNotFoundException("Route not found.");
        }
    }
}