<?php

namespace Faker\Provider\fa_IR;

class Person extends \Faker\Provider\Person
{
    protected static $maleNameFormats = [
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{firstNameMale}} {{lastName}}',
        '{{titleMale}} {{firstNameMale}} {{lastName}}',
    ];

    protected static $femaleNameFormats = [
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{firstNameFemale}} {{lastName}}',
        '{{titleFemale}} {{firstNameFemale}} {{lastName}}',
    ];

    /**
     * @link https://sites.google.com/site/farshidfarhat/boy-names
     */
    protected static $firstNameMale = [
        'آبان', 'آبتین', 'آبید', 'آتش', 'آتشبان', 'آتشبند', 'آتیلا', 'آدر', 'آذران', 'آذربُد', 'آذرتش', 'آذرداد', 'آذرنگ', 'آرآسب', 'آرا', 'آراد', 'آرام', 'آران', 'آرتاباز', 'آرتان', 'آرتای', 'آرتمان', 'آرتین', 'آرش', 'آرمان', 'آرمون', 'آرمین', 'آرنگ', 'آرون', 'آروین', 'آریا', 'آریاآسب', 'آریابد', 'آریارمنا', 'آریامن', 'آریامنش', 'آریان', 'آریانا', 'آریانو', 'آریوبرزن', 'آزاد', 'آصف', 'آلتون', 'آوگان', 'آوند', 'آیتان', 'آیدین',
        'ابراهیم', 'ابوعلی', 'ابی', 'اپرنگ', 'اتابک', 'اُجای', 'احد', 'احسان', 'احمد', 'اُخشان', 'ادریس', 'ارجاسپ', 'ارجان', 'ارجمند', 'اردا', 'اردشیر', 'اردلان', 'اردوان', 'اردون', 'ارزین', 'ارژن', 'ارژنگ', 'ارستو', 'ارسلان', 'ارسیا', 'ارشاسب', 'ارشام', 'ارشاما', 'ارشان', 'ارشد', 'ارشک', 'ارشمید', 'ارشن', 'ارشیا', 'ارمیا', 'اُرند', 'اروند', 'اسد', 'اسفندیار', 'اسفندیار', 'اسلان', 'اسماعیل', 'اشکان', 'اصغر', 'افراسیاب', 'افرند', 'افرنگ', 'افشار', 'افشین', 'اقبال', 'اکبر', 'اکتای', 'البرز', 'الوند', 'الیا', 'الیاس', 'امجد', 'امید', 'امیر', 'امین', 'انوش', 'انوشیروان', 'اوتانا', 'اوتبر', 'اورنگ', 'اورنگ', 'اُوژن', 'اوشنر', 'ایاز', 'ایراف', 'ایرج', 'ایرمان', 'ایزد', 'ایلا', 'ایمان',
        'بابک', 'باران', 'باربد', 'بارمان', 'بارین', 'بازان', 'بازور', 'بازیار', 'باستام', 'باستین', 'باسیم', 'باشو', 'بامداد', 'بامشاد', 'بامین', 'باور', 'باورد', 'باوند', 'بختیار', 'برجسب', 'برخیا', 'بردیا', 'برزو', 'برزویه', 'برزین', 'برزین', 'برسام', 'برمک', 'برنا', 'برید', 'برین', 'بزرگمهر', 'بشیر', 'بکتاش', 'بلاش', 'بلکا', 'بنان', 'بهادر', 'بهار', 'بهامین', 'بهبود', 'بهپور', 'بهجان', 'بهداد', 'بهدین', 'بهراد', 'بهرام', 'بهرخ', 'بهرنگ', 'بهروز', 'بهزاد', 'بهفر', 'بهکام', 'بهمرد', 'بهمن', 'بهمنیار', 'بهنام', 'بهنیا', 'بهنیود', 'بیژن', 'بینا',
        'پاتون', 'پارسا', 'پاریا', 'پاساد', 'پاشا', 'پاینده', 'پدرام', 'پرتاش', 'پرتام', 'پردیس', 'پرشاد', 'پرشند', 'پرشین', 'پرنگ', 'پرهام', 'پرویز', 'پژمان', 'پُژمان', 'پژواک', 'پشنگ', 'پِشنگ', 'پورنگ', 'پوریا', 'پولاد', 'پویا', 'پویان', 'پیام', 'پیدافر', 'پیران', 'پیروز', 'پیمان', 'پیوند',
        'تابال', 'تاج', 'تاجفر', 'تاجور', 'تراب', 'تلیمان', 'تهماسب', 'تهمتن', 'تهمین', 'توتک', 'تورج', 'تورک', 'تیران', 'تیربُد', 'تیرداد', 'تیرگر', 'تیرنام', 'تیشتار', 'تیمور', 'تینوش',
        'ثابت',
        'جاماسب', 'جامی', 'جاوید', 'جبّار', 'جعفر', 'جلال', 'جلایل', 'جمال', 'جمشید', 'جهان', 'جهانبان', 'جهانبخت', 'جهانبخش', 'جهاندار', 'جهانسوز', 'جهانشاد', 'جهانشاه', 'جهانشیر', 'جهانفر', 'جهانگیر', 'جهانمهر', 'جهانیار', 'جواد', 'جوانشیر', 'جوریل', 'جویان',
        'چاووش', 'چکاد', 'چنگیز',
        'حافظ', 'حامد', 'حامی', 'حانی', 'حبیب', 'حسام', 'حسن', 'حسین', 'حمید', 'حیدر',
        'خرداد', 'خرسند', 'خسرو', 'خشایار',
        'دابا', 'داتیس', 'دادبه', 'دادبین', 'دادفر', 'دادمهر', 'دادور', 'دارا', 'داراب', 'دارمان', 'داریا', 'داریان', 'داریوش', 'دامون', 'دانا', 'دانش', 'دانوش', 'دانیال', 'داور', 'داوود', 'دریا دل', 'دلاور', 'دلیر', 'دولت', 'دیاکو',
        'راجی', 'راد', 'رادبد', 'رادمان', 'رادمنش', 'رادمهر', 'رادین', 'رازان', 'رازبان', 'رازی', 'راستین', 'رامبُد', 'رامتین', 'رامی', 'رامیاد', 'رامیار', 'رامین', 'راهزاد', 'رایان', 'رایکا', 'رحیم', 'رخشان', 'رزین', 'رسام', 'رستم', 'رسول', 'رشید', 'رشین', 'رضا', 'رُکندین', 'رها', 'رهاد', 'رهام', 'رهام', 'روئین', 'روزبه', 'روشاک', 'روشان',
        'زاب', 'زادفر', 'زادمهر', 'زال', 'زامیاد', 'زاهد', 'زاور', 'زراسب', 'زرتشت', 'زروان', 'زروند', 'زریر', 'زکریا', 'زند', 'زواره',
        'ژاژه', 'ژامک', 'ژرفا', 'ژکفر', 'ژوبین', 'ژیان', 'ژیانفر', 'ساتراپ',
        'ساتیار', 'ساحل', 'سارنگ', 'ساسان', 'ساعد', 'سالار', 'سام', 'سامان', 'سامی', 'سامیار', 'سامین', 'ساویز', 'سپنتا', 'سپنتمان', 'سپند', 'سپندار', 'سپهر', 'ستّار', 'ستوده', 'سردار', 'سرمد', 'سرمند', 'سرواد', 'سروش', 'سریر', 'سعید', 'سلم', 'سلمان', 'سلمک', 'سلیم', 'سلیمان', 'سمراد', 'سمند', 'سمیر', 'سنجر', 'سهراب', 'سهند', 'سهیل', 'سوران', 'سورنا', 'سوشیانت', 'سوفرا', 'سیامک', 'سیاوش', 'سیرمان', 'سیروس', 'سینا', 'سینام', 'سیوا',
        'شاپور', 'شادان', 'شادرخ', 'شادروز', 'شادمهر', 'شادورد', 'شارود', 'شاهد', 'شاهرخ', 'شاهور', 'شاهین', 'شایا', 'شایان', 'شایگان', 'شباویز', 'شبدیز', 'شجاع', 'شروین', 'شریف', 'شمسا', 'شمیل', 'شهاب', 'شهباز', 'شهبال', 'شهبد', 'شهپر', 'شهداد', 'شهراب', 'شهراد', 'شهرام', 'شهرباز', 'شهرداد', 'شهروز', 'شهریار', 'شهکام', 'شهنام', 'شهیار', 'شولان', 'شووان', 'شیداسب', 'شیدفر', 'شیده', 'شیدوش', 'شیرزاد', 'شیروان', 'شیرویه',
        'صابر', 'صادق', 'صبا', 'صدری', 'صدیق', 'صلاح', 'صلاح الدین', 'صمد',
        'ضیا',
        'طاهر', 'طهمورث', 'طوس', 'طوفان',
        'ظفر',
        'عادل', 'عارف', 'عبّاس', 'عدلان', 'عرفان', 'عزیز', 'عطا', 'عظیم', 'علی', 'علی داد', 'عماد', 'عمید', 'عنایت',
        'غدیر',
        'فاتک', 'فاریا', 'فاضل', 'فراز', 'فرازمان', 'فرامرز', 'فرامین', 'فربد', 'فرتاش', 'فرتوس', 'فرج', 'فرجاد', 'فرجام', 'فرّخ', 'فرخاد', 'فرّخزاد', 'فردات', 'فرداد', 'فردوس', 'فردید', 'فردیس', 'فردین', 'فردین', 'فرزاد', 'فرزام', 'فرزان', 'فرزین', 'فرساد', 'فرشاد', 'فرشید', 'فرشیدورد', 'فرشین', 'فرلاس', 'فرناد', 'فرنام', 'فرنود', 'فرهاد', 'فرهان', 'فرهد', 'فرهنگ', 'فرهود', 'فرود', 'فروَد', 'فرورتیش', 'فروردین', 'فروهر', 'فریان', 'فریان', 'فریبرز', 'فرید', 'فریدون', 'فریس', 'فریمان', 'فرینام', 'فریور', 'فیروز', 'فیلک',
        'قادر', 'قاسم', 'قباد', 'قدرت', 'قلندر', 'قیصر',
        'کارن', 'کاظم', 'کام', 'کامبخش', 'کامبد', 'کامبیز', 'کامبین', 'کامدین', 'کامران', 'کامشاد', 'کامکار', 'کاموس', 'کامیار', 'کاوان', 'کاوه', 'کاووس', 'کاویان', 'کتیبه', 'کریم', 'کریمان', 'کریمداد', 'کسرا', 'کشواد', 'کلباد', 'کمال', 'کمبوجیه', 'کواد', 'کورُس', 'کورش', 'کورنگ', 'کوشا', 'کوشان', 'کوشیار', 'کوهیار', 'کیارش', 'کی آرمین', 'کیا', 'کیان', 'کَیان', 'کیانوش', 'کیانوش', 'کیاوش', 'کیخسرو', 'کیقباد', 'کیکاووس', 'کیهان', 'کیوان', 'کیومرث',
        'گرزم', 'گرشاسب', 'گرگین', 'گشتاسب', 'گودرز', 'گورنگ', 'گوشاسب', 'گوماتا', 'گیو',
        'لسان', 'لهراسب', 'لیث',
        'مازار', 'مازیار', 'ماکان', 'مانک', 'مانوش', 'مانی', 'ماهان', 'ماهر', 'متین', 'مجتبی', 'مجید', 'محسن', 'محمّد', 'محمود', 'مراد', 'مرتضی', 'مرتیا', 'مردآویج', 'مرداس', 'مرزبان', 'مروان', 'مزدا', 'مزدک', 'مسعود', 'مصطفی', 'معین', 'مقصود', 'مکابیز', 'مَلِک', 'ملیک', 'منصور', 'منوچهر', 'مهبد', 'مهداد', 'مهدی', 'مهرا', 'مهراب', 'مهراد', 'مهراشک', 'مهرام', 'مهرام', 'مهران', 'مهربان', 'مهرتاش', 'مهرداد', 'مهرزاد', 'مهرساد', 'مهرشاد', 'مهرک', 'مهرگان', 'مهرنام', 'مهرنگ', 'مهرنوش', 'مهرورز', 'مهروند', 'مهریار', 'مهریار', 'مهوار', 'مهوند', 'مهیار', 'مهیاز', 'مهیمن', 'موسی', 'میثاق', 'میثم', 'میرزا', 'میعاد', 'میلاد',
        'نادر', 'ناصر', 'نامدار', 'نامور', 'نامی', 'نجید', 'نرسی', 'نریمان', 'نَستور', 'نشواد', 'نصرت', 'نصیح', 'نصیر', 'نظام', 'نعمت', 'نوبان', 'نوروز', 'نوری', 'نوزر', 'نوژان', 'نوشزاد', 'نوشیروان', 'نوند', 'نویان', 'نوید', 'نوین', 'نیرَم', 'نیرو', 'نیک', 'نیک آهنگ', 'نیکا', 'نیکان', 'نیکاو', 'نیکروز', 'نیکزاد', 'نیکنام', 'نیکنیا', 'نیما', 'نیماد', 'نیناد', 'نیو', 'نیواد', 'نیوتور', 'نیوراد', 'نیوزاد', 'نیوشا', 'نیوند',
        'هاتف', 'هادی', 'هارون', 'هاشم', 'هامان', 'هامون', 'هدایت', 'هرمز', 'هژیر', 'هشام', 'همایون', 'هوتن', 'هورداد', 'هوشان', 'هوشمند', 'هوشنگ', 'هوشیار', 'هومان', 'هومن', 'هومین', 'هونام', 'هیتاسب', 'هیراد', 'هیربد', 'هیرسا', 'هیرمند', 'هیوند',
        'وارتان', 'واروژ', 'واریان', 'والا', 'واله', 'وجیح', 'وحدت', 'وحید', 'ورجاوند', 'ورشاسب', 'ورفان', 'ورنا', 'وُریا', 'وشمگیر', 'وفا', 'ونداد', 'وهاب', 'وهبد', 'وهرز', 'ویراف', 'ویسه', 'ویشپر', 'ویشتاسب',
        'یاران', 'یاری', 'یازان', 'یاشار', 'یامین', 'یاور', 'یاوند', 'یحیی', 'یزدان', 'یزدان بخش', 'یزدانفر', 'یزدگرد', 'یعقوب', 'یوسف', 'یونس',
    ];

    /**
     * @link https://sites.google.com/site/farshidfarhat/girl-names
     */
    protected static $firstNameFemale = [
        'آبان', 'آبان بانو', 'آبان دخت', 'آتاناز', 'آتسا', 'آتنا', 'آتنه', 'آتوسا', 'آتوشه', 'آتیشه', 'آذر', 'آذرافروز', 'آذران', 'آذرجهر', 'آذرخش', 'آذرداد', 'آذردخت', 'آذرشین', 'آذرفروز', 'آذرک', 'آذرگل', 'آذرگون', 'آذرمهر', 'آذرمینا', 'آذرنوش', 'آذروان', 'آذریاس', 'آذرین', 'آذین', 'آذین بانو', 'آذین دخت', 'آرا', 'آراسته', 'آرام بانو', 'آرایه', 'آرتا', 'آرتادخت', 'آرتمیس', 'آرتنوس', 'آرزو', 'آرسته', 'آرمان', 'آرمیتا', 'آرمیلا', 'آرمین دخت', 'آروشا', 'آریا', 'آریان', 'آریانا', 'آرین', 'آرین', 'آزاد دخت', 'آزادمهر', 'آزاده', 'آزرمیدخت', 'آزیتا', 'آژند', 'آسا', 'آسام', 'آسمان', 'آسمانه', 'آسیا', 'آسیه', 'آصفه', 'آفاق', 'آفتاب', 'آفری', 'آفرین', 'آلاله', 'آلما', 'آلیش', 'آمنه', 'آموتیا', 'آمیتریس', 'آمیتریس', 'آمیتیس', 'آنا', 'آناهیتا', 'آندیا', 'آنوش', 'آنیتا', 'آهنگ', 'آهو', 'آوا', 'آوازه', 'آوند', 'آوید', 'آویده', 'آویز', 'آویزه', 'آویژه', 'آویسا', 'آویش', 'آویشن', 'آویشه', 'آوین', 'آیتان', 'آیدا', 'آیدان', 'آیسا', 'آیسان', 'آیسان', 'آیسل', 'آیلا', 'آیلین', 'آیناز', 'آیه', 'ابریشم', 'احترام', 'اختر', 'ارانوس', 'ارزین', 'ارستو', 'ارغوان', 'ارکیده', 'ارم', 'ارمغان', 'ارنواز', 'اروانه', 'اروسا', 'اریکا', 'اِستاتیرا', 'استر', 'اشرف', 'اعظم', 'افتخار', 'افرا', 'افرند', 'افروز', 'افروزه', 'افری', 'افسان', 'افسانه', 'افسر', 'افسون', 'افشان', 'افشانه', 'افشک', 'افشنگ', 'افشید', 'افشیده', 'افشینه', 'اکرم', 'الدوز', 'الفت', 'الماس', 'المیرا', 'الناز', 'الهام', 'الهه', 'الیا', 'الیزه', 'الیکا', 'امیتیس', 'امید', 'امیده', 'امیربانو', 'امیره', 'انارام', 'اندیشه', 'انسی', 'انسیه', 'انور', 'انوشا', 'انوشک', 'انوشه', 'انیس', 'انیسا', 'انیسه', 'اورسیا', 'اوزن', 'اولیا', 'ایده', 'ایران', 'ایران بانو', 'ایران دخت', 'ایرسا', 'ایرسیا', 'ایلا', 'ایمان',
        'بابوک', 'باران', 'بارانک', 'بارانه', 'بامی', 'بامیک', 'بامین', 'باناز', 'بانو', 'بانویه', 'بدری', 'بدریه', 'برسابه', 'برسین', 'برسینا', 'بلور', 'بنفشه', 'به آذر', 'به آذین', 'به آرا', 'به آفرید', 'به آفرین', 'به بها', 'بها', 'بهار', 'بهاربانو', 'بهارک', 'بهاره', 'بهاک', 'بهامین', 'بهتام', 'بهتن', 'بهجان', 'بهجت', 'بهدخت', 'بهدله', 'بهدیس', 'بهرامن', 'بهرخ', 'بهرو', 'بهشته', 'بهشید', 'بهمیس', 'بهناز', 'بهناک', 'بهنوش', 'بههن', 'بهی', 'بهین', 'بهینه', 'بوبک', 'بوران', 'بوران دخت', 'بوسه', 'بی بی', 'بی بی ناز', 'بیتا', 'بیدخت',
        'پاپلی', 'پاتونه', 'پارسادخت', 'پارمیس', 'پارمین', 'پارنیز', 'پاکسیما', 'پاکنوش', 'پالیز', 'پانته آ', 'پانویه', 'پانیذ', 'پدیده', 'پرتو', 'پرخیده', 'پردیس', 'پرستان', 'پرسته', 'پرستو', 'پرستوک', 'پرسون', 'پرشاد', 'پرشنگ', 'پرشه', 'پرگل', 'پرمون', 'پرمیدا', 'پرنا', 'پرناز', 'پرند', 'پرندیس', 'پرندین', 'پرنگ', 'پرنو', 'پرنیا', 'پرنیان', 'پروا', 'پروان', 'پروانه', 'پروچیستا', 'پرور', 'پروسکا', 'پروشات', 'پروند', 'پروه', 'پروین', 'پری', 'پری دخت', 'پری رو', 'پریا', 'پریجهان', 'پریچهر', 'پریچهره', 'پریزاد', 'پریسا', 'پریساتیس', 'پریسان', 'پریسوز', 'پریسیما', 'پریشاد', 'پریشم', 'پریما', 'پرین', 'پریناز', 'پریناز', 'پرینوش', 'پریور', 'پریوش', 'پژواک', 'پسند', 'پگاه', 'پلاگه', 'پوپک', 'پوپه', 'پوران', 'پوران دخت', 'پورکار', 'پوری', 'پونل', 'پونه', 'پیچک', 'پیراسته', 'پیرایه', 'پیروزدخت', 'پیروزه', 'پیمانه', 'پیموده', 'پیوند',
        'تابا', 'تابان', 'تابش', 'تاج بانو', 'تارا', 'تانیا', 'تبسم', 'ترانه', 'ترسا', 'ترمه', 'ترنگ', 'تکتم', 'تندیس', 'تهمینه', 'توتک', 'توران', 'توران خت', 'توریا', 'توسکا', 'توکا', 'تیبا', 'تیرا', 'تیراژه', 'تیرام', 'تیکا', 'تینا',
        'ثریّا', 'ثمر', 'ثمره', 'ثمن', 'ثمیلا', 'ثمینا',
        'جامک', 'جانان', 'جانفروز', 'جاودانه', 'جبّاره', 'جریره', 'جلا', 'جلوه', 'جلیله', 'جمیله', 'جنّت', 'جهان', 'جهان آرا', 'جهان بانو', 'جهان تاب', 'جهان دخت', 'جهان ناز', 'جوانه', 'جیران',
        'چامه', 'چشمک', 'چکا', 'چکامه', 'چکاوک', 'چلیپا', 'چمان', 'چمانه', 'چمن', 'چیترا', 'چیستا', 'چیکا',
        'حاتفه', 'حامده', 'حامی', 'حامیه', 'حبیبه', 'حدا', 'حدیث', 'حدیقه', 'حرمت', 'حریره', 'حسنا', 'حلیمه', 'حمیده', 'حمیرا', 'حنا', 'حوّا', 'حور', 'حورا', 'حوروش', 'حوری', 'حوریه',
        'خاتون', 'خاطره', 'خاور', 'خاوردخت', 'خجسته', 'خدیجه', 'خزر', 'خندان', 'خنده', 'خنیا', 'خورشاد', 'خورشید', 'خورشید بانو', 'خوروش', 'خوشه', 'خینا',
        'دامینه', 'دانا', 'دانه', 'داور', 'دردانه', 'درسا', 'درنا', 'درناز', 'دری', 'دریا', 'دریاناز', 'دریانه', 'دل آرا', 'دل آسا', 'دل آویز', 'دل افرز', 'دلارام', 'دلبر', 'دلبند', 'دلربا', 'دلشاد', 'دلکش', 'دلناز', 'دلنواز', 'دلیار', 'دلیله', 'دنا', 'دنیا', 'دنیازاد', 'دنیاناز', 'دیبا', 'دینا', 'دینک', 'دینه',
        'راحله', 'راحیل', 'رادنوش', 'راز', 'رازان', 'رازک', 'راستا', 'راستاک', 'راستینه', 'راسن', 'راشین', 'راضیه', 'راضیه', 'راما', 'رامبهشت', 'رامدخت', 'رامش', 'رامک', 'رامونا', 'رامین دخت', 'رامینا', 'رامینه', 'راهله', 'راوک', 'رایکا', 'رباب', 'ربابه', 'رجاء', 'رخسارا', 'رخساره', 'رخشا', 'رخشاد', 'رخشاد', 'رخشان', 'رخشان', 'رخند', 'رُدگون', 'ردیمه', 'رزما', 'رسا', 'رشا', 'رشاد', 'رشیا', 'رضوان', 'رعنا', 'رفا', 'رقیّه', 'رکسانا', 'رها', 'رهادخت', 'روا', 'روان', 'روجا', 'روح انگیز', 'رودابه', 'روزچهر', 'روژان', 'روژین', 'روژینا', 'روشانه', 'روشن', 'روشنا', 'روشنک', 'رومینا', 'روناک', 'رونق', 'رویا', 'رویا', 'ریتا', 'ریحان', 'ریحانک', 'ریحانه', 'ریکا', 'ریما', 'ریماز',
        'زرآسا', 'زرافشان', 'زربانو', 'زرسا', 'زری', 'زریله', 'زرّین', 'زرّین تاج', 'زرّین دخت', 'زرّینه', 'زنبق', 'زها', 'زهرا', 'زهره', 'زوزان', 'زویا', 'زیبا', 'زیباچهر', 'زیبادخت', 'زیکا', 'زینا', 'زینب', 'زینت', 'زیور',
        'ژاله', 'ژامک', 'ژاوه', 'ژیلا', 'ژیله', 'ژینا',
        'ساحل', 'سارا', 'سارنگ', 'ساره', 'سارینا', 'ساغر', 'ساقی', 'سالومه', 'سامه', 'سامیه', 'ساناز', 'سانوا', 'ساویس', 'ساینا', 'سایه', 'سپنتا', 'سپهرم', 'سپیدا', 'سپیده', 'سپینود', 'ستاره', 'ستّاره', 'ستاه', 'ستوده', 'سحر', 'سحرناز', 'سرمه', 'سرور', 'سرور', 'سروشه', 'سروناز', 'سروند', 'سروین', 'سزانه', 'سعیده', 'سلا', 'سلامه', 'سلما', 'سلماز', 'سلمه', 'سلیمه', 'سماء', 'سمانه', 'سمراد', 'سمن', 'سمناز', 'سمنبر', 'سمنه', 'سمیرا', 'سمیره', 'سمینه', 'سمیّه', 'سنبل', 'سها', 'سهی', 'سهیلا', 'سودابه', 'سورا', 'سوران', 'سوری', 'سوزان', 'سوسن', 'سوسنک', 'سوگل', 'سوگلی', 'سوگند', 'سیتا', 'سیتا', 'سیرادخت', 'سیرانوش', 'سیکا', 'سیما', 'سیماه', 'سیمبر', 'سیمتن', 'سیمیا', 'سیمین', 'سیمین دخت', 'سیندخت', 'سیوا',
        'شاپرک', 'شادآفرین', 'شادان', 'شادمان', 'شادناز', 'شاده', 'شادی', 'شالیزه', 'شاندیز', 'شاهپری', 'شاهد', 'شاهزاده', 'شاهگل', 'شاهنگ', 'شاهوش', 'شاورد', 'شاوه', 'شایا', 'شایان دخت', 'شایسته', 'شباهنگ', 'شبپر', 'شبناز', 'شبنم', 'شده', 'شراره', 'شرمین', 'شروین', 'شریفه', 'شعله', 'شفق', 'شقایق', 'شکرانه', 'شکوفه', 'شکوه', 'شکیبا', 'شمس', 'شمسی', 'شمیا', 'شمیسا', 'شمیلا', 'شمیم', 'شمین', 'شهپر', 'شهرا', 'شهرزاد', 'شهرناز', 'شهرناو', 'شهرنواز', 'شهرنوش', 'شهره', 'شهرود', 'شهلا', 'شهناز', 'شهنواز', 'شهین', 'شورانگیز', 'شورت', 'شوشا', 'شوکا', 'شوکت', 'شیبا', 'شیدا', 'شیدخت', 'شیدرخ', 'شیده', 'شیدوش', 'شیراز', 'شیردخت', 'شیرین', 'شیرین بانو', 'شیفته', 'شیما', 'شیوا', 'شیواد', 'شیوه',
        'صابره', 'صبا', 'صدا', 'صدف', 'صدیقه', 'صفا', 'صفورا', 'صفیّه', 'صنم', 'صنوبر', 'صهبا',
        'طاهره', 'طاوس', 'طراوت', 'طلا', 'طلایه', 'طلعت', 'طناز', 'طوبی', 'طوسک', 'طوفان', 'طیبه',
        'ظریف', 'ظریفه',
        'عادله', 'عادیله', 'عاطفه', 'عالیه', 'عبّاسه', 'عدیله', 'عذرا', 'عزیز', 'عزیزه', 'عسل', 'عصمت', 'عطیفه', 'عفت', 'عقدس', 'عقیق', 'عنبر', 'عهدیه',
        'غزال', 'غزاله', 'غزل', 'غمزه', 'غنچه',
        'فائزه', 'فائقه', 'فاخته', 'فاخره', 'فاریا', 'فاطمه', 'فتّانه', 'فتنه', 'فخری', 'فرانک', 'فرانه', 'فرح', 'فرحناز', 'فرخ رو', 'فرخروز', 'فرخنده', 'فردخت', 'فردوس', 'فرزانک', 'فرزانه', 'فرشته', 'فرشیده', 'فرمهر', 'فرناز', 'فرنگ', 'فرنگیس', 'فرنوش', 'فرنیا', 'فروز', 'فروزا', 'فروزان', 'فروزنده', 'فروغ', 'فریا', 'فریال', 'فریبا', 'فریدا', 'فریده', 'فریفته', 'فریما', 'فریماه', 'فریمهر', 'فرین', 'فریّن', 'فریّن چهر', 'فریناز', 'فرینام', 'فرینوش', 'فقیهه', 'فلامک', 'فلورا', 'فهیمه', 'فوژان', 'فیروزه', 'فیلا',
        'قاسدک', 'قدسی', 'قشنگ', 'قمر',
        'کاژیره', 'کاساندان', 'کاملیا', 'کامینه', 'کاناز', 'کبری', 'کتانه', 'کتایون', 'کترا', 'کرشمه', 'کژال', 'کلاله', 'کمند', 'کوکب', 'کیان دخت', 'کیانا', 'کیدرا', 'کیمیا', 'کیهان', 'کیهان بانو',
        'گردآفرید', 'گردیا', 'گل آذین', 'گل افشار', 'گل افشان', 'گل اندام', 'گل نسرین', 'گلاب', 'گلاره', 'گلاره', 'گلاره', 'گلاویز', 'گلاویژ', 'گلایل', 'گلبان', 'گلبانو', 'گلبرگ', 'گلبهار', 'گلبو', 'گلپر', 'گلپری', 'گلچهر', 'گلچهره', 'گلدار', 'گلدوز', 'گلرخ', 'گلرنگ', 'گلرو', 'گلریز', 'گلسا', 'گلسان', 'گلشاد', 'گلشن', 'گلشنک', 'گلشهر', 'گلشید', 'گلشیفته', 'گلک', 'گلگون', 'گلمهر', 'گلنار', 'گلناز', 'گلنام', 'گلنسا', 'گلنواز', 'گلنوش', 'گلی', 'گوهر', 'گوهرشاد', 'گیتا', 'گیتی', 'گیسو', 'گیسی', 'گیلدا',
        'لادن', 'لاله', 'لبینا', 'لطیفه', 'لُعبت', 'لعیا', 'لوما', 'لیان', 'لیدا', 'لیلا', 'لیلا', 'لیلاس', 'لیلوپر', 'لیلی', 'لیلی', 'لیلیا', 'لیما', 'لینا',
        'مائده', 'مارال', 'ماریه', 'مامک', 'مامیسا', 'مانا', 'ماندا', 'ماندیس', 'مانلی', 'مانی', 'مانیا', 'ماه آفرد', 'ماهدخت', 'ماهرخ', 'ماهرخسارر', 'ماهرو', 'محبوبه', 'محیا', 'مدینه', 'مراجل', 'مرجان', 'مرجانه', 'مرسده', 'مرضیه', 'مرمر', 'مروارید', 'مریم', 'مژده', 'مژگان', 'مستانه', 'مستوره', 'مشیا', 'معصومه', 'ملاحت', 'ملکه', 'ملکه جهان', 'ملود', 'ملودی', 'ملوس', 'ملوک', 'ملیح', 'ملیحه', 'ملیسا', 'ملیکا', 'منصوره', 'منظر', 'منوّر', 'منیر', 'منیره', 'منیژه', 'منیلا', 'مه سیما', 'مه منیر', 'مها', 'مهان', 'مهبانو', 'مهتا', 'مهتاب', 'مهتاج', 'مهجبین', 'مهداد', 'مهدخت', 'مهدیس', 'مهدیه', 'مهرآرا', 'مهرآسا', 'مهرآفرین', 'مهرا', 'مهراز', 'مهران', 'مهراندخت', 'مهرانگیز', 'مهرانه', 'مهراور', 'مهراوه', 'مهربانو', 'مهرخ', 'مهردخت', 'مهرزاد', 'مهرسا', 'مهرشید', 'مهرک', 'مهرناز', 'مهرنوش', 'مهرورز', 'مهروش', 'مهری', 'مهزاد', 'مهسا', 'مهسان', 'مهستی', 'مهسو', 'مهشاد', 'مهشید', 'مهفام', 'مهکامه', 'مهلا', 'مهلقا', 'مهناز', 'مهنوش', 'مهوش', 'مهین', 'مهین بانو', 'مهیندخت', 'موجان', 'موژان', 'مونا', 'مونا', 'میترا', 'میثاق', 'میثمه', 'میچکا', 'میشا', 'میلا', 'میلی', 'مینا', 'مینو', 'میهن', 'میهن یار',
        'ناجی', 'نادره', 'نادی', 'نادیا', 'نارسیس', 'نارین', 'ناز', 'نازآفرین', 'نازبانو', 'نازبو', 'نازپری', 'نازتا', 'نازدانه', 'نازدخت', 'نازک', 'نازگل', 'نازلی', 'نازنوش', 'نازنین', 'نازو', 'نازی', 'نازیتا', 'نازیلا', 'نازینه', 'ناژو', 'ناژین', 'ناناز', 'ناهید', 'ناهیده', 'نجلا', 'نجمه', 'نجوی', 'ندا', 'نرجس', 'نرگس', 'نرمین', 'نرمینه', 'نزهت', 'نسا', 'نسترن', 'نسرین', 'نسیم', 'نشاط', 'نشوا', 'نشید', 'نظیره', 'نغمه', 'نفیسه', 'نکیسا', 'نگار', 'نگارین', 'نگان', 'نگاه', 'نگین', 'نهال', 'نهاله', 'نوا', 'نواز', 'نوال', 'نوبر', 'نور', 'نورا', 'نورانگیز', 'نوژان', 'نوشآفرین', 'نوشا', 'نوشابه', 'نوشبر', 'نوشه', 'نوشین', 'نوشینه', 'نوگل', 'نویده', 'نویسه', 'نوین', 'نیاز', 'نیاز', 'نیّر', 'نیرا', 'نیّره', 'نیسا', 'نیسیا', 'نیکا', 'نیکپر', 'نیکتا', 'نیکدخت', 'نیکدل', 'نیکناز', 'نیکی', 'نیکی', 'نیکی ناز', 'نیلگون', 'نیلوفر', 'نینا', 'نیوشا', 'نیوشه',
        'هاله', 'هانا', 'هاني', 'هانيه', 'هایده', 'هدیه', 'هستی', 'هلاله', 'هما', 'همای', 'همراز', 'هنگامه', 'هوردخت', 'هورشید', 'هیلا', 'هیلا', 'هیلدا', 'هیوا',
        'وارسته', 'واژه', 'واله', 'وانوشه', 'وجستا', 'وجیهه', 'ورتا', 'ورد', 'وردا', 'ورسا', 'ورنا', 'وستا', 'وشتا', 'وشتی', 'وصال', 'وندا', 'ونیژه', 'ویدا', 'ویرا', 'ویره', 'ویژه', 'ویس', 'ویستا', 'ویشکا', 'وینا',
        'یارا', 'یاس', 'یاسمن', 'یاسمین', 'یاقوت', 'یزدانه', 'یکامه', 'یکتا', 'یگانه', 'یلدا', 'یوتاب',
    ];

    /**
     * @link http://fa.wikipedia.org/wiki/%D8%B1%D8%AF%D9%87:%D9%86%D8%A7%D9%85%E2%80%8C%D9%87%D8%A7%DB%8C_%D8%AE%D8%A7%D9%86%D9%88%D8%A7%D8%AF%DA%AF%DB%8C_%D8%B2%D8%A8%D8%A7%D9%86%E2%80%8C%D9%87%D8%A7%DB%8C_%D8%A7%DB%8C%D8%B1%D8%A7%D9%86%DB%8C
     */
    protected static $lastName = [
        'آختاچی', 'آدینه', 'آریان‌پور', 'آشتیانی', 'آشنا', 'آشوری', 'آقاجری', 'آهنگر', 'آهنگری', 'آهی', 'آژند', 'آیتی', 'آیت‌اللهی',
        'ابتکار', 'ابریشمی', 'ابطحی', 'ابوذر', 'ادب', 'ادیانی', 'ارسباران', 'استادی', 'اشتری', 'اشراقی', 'اشکوری', 'اصفهانی', 'اصلانی', 'اعتبار', 'اعتماد', 'اعلم', 'افخم', 'افخمی', 'اقلیما', 'اللهیاری', 'الهام', 'امانت', 'امانی', 'امیری', 'امین‌زاده', 'انتظامی', 'انوار', 'انوری', 'انوشه', 'اوستا', 'ایمانی',
        'باستانی', 'باطنی', 'باغچه‌بان', 'باهنر', 'بحرینی', 'بخاری', 'بختیار', 'بختیاری', 'بدخشانی', 'برزویی', 'بزرگی', 'بزرگیان', 'بزرگ‌نیا', 'بهاور', 'بهبهانی', 'بهشتی', 'بیگی',
        'پارسا', 'پارسی', 'پازارگاد', 'پازوکی', 'پایا', 'پایدار', 'پایور', 'پستا', 'پناهنده', 'پناهی', 'پناهیان', 'پورناظری', 'پورنگ', 'پویان', 'پیران', 'پیرحیاتی', 'پیوندی',
        'تبریزی', 'ترکاشوند', 'ترکان', 'تهرانی', 'توسلی', 'توفیق', 'توفیقی', 'توکل', 'توکلیان',
        'ثابتی',
        'جعفریان', 'جمادی', 'جنتی', 'جهانبگلو', 'جهانگیری', 'جهانی',
        'چاوشی', 'چلبی', 'چنگیزی', 'چگنی',
        'حائری', 'حبیبی', 'حجتی', 'حسابی', 'حقانی', 'حقیقی', 'حکمت', 'حکمی', 'حکیمی', 'حیاتی',
        'خاتمی', 'خامنه‌ای', 'خاموشی', 'خداپناهی', 'خدایی', 'خراسانی', 'خرم‌آبادی', 'خسروپناه', 'خمسه', 'خوئینی', 'خوئینی‌ها', 'خیابانی',
        'داد', 'دانایی‌فر', 'دانایی‌فرد', 'داودی', 'داور', 'دباغ', 'درگاهی', 'دری', 'دستغیب', 'دهقان', 'دیباج',
        'ذاکری',
        'راسخ', 'راوندی', 'رجایی', 'رحماندوست', 'رحمانیان', 'رستمی', 'رسولی', 'رفیعی', 'رنجبر', 'رنگرز', 'رهنما', 'روحانی', 'روزبه', 'روستا',
        'زارع', 'زالی', 'زرشناس', 'زمردیان', 'زنجانی', 'زنوزی', 'زهرایی', 'زین‌الدین',
        'سادات', 'ساعی', 'سبحانی', 'سبزواری', 'ستاری', 'سحاب', 'سحابی', 'سراج', 'سرشار', 'سرمد', 'سروستانی', 'سروش', 'سلامت', 'سپه‌وند', 'سیف', 'سیف‌زاده',
        'شادمهر', 'شاملو', 'شاه‌حسینی', 'شبستری', 'شجاعی', 'شرع‌پسند', 'شرف', 'شریعتمداری', 'شریعتی', 'شریف', 'شریفیان', 'شعبانی', 'شفا', 'شهیدی', 'شیخ‌الاسلامی', 'شیدا', 'شیرازی', 'شیرمحمدی', 'شیروانی',
        'کاشی', 'کاملی', 'کامکار', 'کاویانی', 'کاکاوند', 'کدیور', 'کرمانی', 'کریمی', 'کلباسی', 'کمالی', 'کهنمویی', 'کوشکی', 'کیان', 'کیانی', 'کیمیایی',
        'گل', 'گلپایگانی', 'گنجی',
        'صانعی', 'صباغ', 'صدر', 'صدیق', 'صدیقی', 'صغیری', 'صفوی',
        'ضابطی', 'ضرغامی',
        'طالب‌زاده', 'طالقانی', 'طباطبائی', 'طبیب‌زاده', 'طریقت',
        'ظریف',
        'عارف', 'عاشوری', 'عالی', 'عبادی', 'عبدالملکی', 'عبدالکریمی', 'عراقی', 'عزیزی', 'عصار', 'عقیلی', 'علم', 'علم‌الهدی', 'علی', 'علیا', 'علی‌آبادی', 'علی‌زمانی', 'علی‌پور', 'عنایت',
        'غضنفری', 'غنی',
        'فارسی', 'فاطمی', 'فانی', 'فتاحی', 'فرامرزی', 'فرج', 'فرشیدورد', 'فرمانفرمائیان', 'فرهنگ', 'فروتن', 'فریاد', 'فنایی', 'فنی‌زاده', 'فهمیده', 'فولادوند',
        'قاضی', 'قانعی', 'قانونی', 'قمیشی', 'قنبری', 'قهرمان', 'قهرمانی', 'قهرمانیان', 'قهستانی',
        'لاجوردی', 'لاهوتی', 'لاچینی', 'لنکرانی', 'لوکس',
        'مجاهد', 'مجتبایی', 'مجتبوی', 'مجتهد', 'مجتهدی', 'مجرد', 'محجوب', 'محجوبی', 'محدثی', 'محمدرضایی', 'محمدی', 'مددی', 'مرادخانی', 'مرتضوی', 'مستوفی', 'مشا', 'مصاحب', 'مصباح', 'مصباح‌زاده', 'مطهری', 'مظفر', 'معارف', 'معروف', 'معین', 'مفتاح', 'مفتح', 'مقدم', 'ملایری', 'ملک', 'ملکیان', 'منوچهری', 'مهاجرانی', 'مهدی‌پور', 'موحد', 'موسوی', 'موسویان', 'میدری', 'میرباقری', 'میردامادی', 'میرزاده', 'میرسپاسی', 'میزبانی',
        'ناظری', 'نامور', 'نجفی', 'ندوشن', 'نراقی', 'نعمت‌زاده', 'نقدی', 'نقیب‌زاده', 'نهاوندی', 'نواب', 'نوبخت', 'نوبختی', 'نیشابوری', 'نیلوفری',
        'هاشمی', 'هاشمی', 'هاشمیان', 'هامون', 'هدایت', 'هراتی', 'هروی', 'همایون', 'همت', 'همدانی', 'هوشیار', 'هومن',
        'واثقی', 'واعظ', 'واعظی', 'واعظ‌زاده', 'وکیلی',
        'یاحقی', 'یثربی', 'یلدا',
    ];

    protected static $titleMale = ['آقای', 'استاد', 'دکتر', 'مهندس'];
    protected static $titleFemale = ['خانم', 'استاد', 'دکتر', 'مهندس'];

    /**
     * This method returns a valid Iranian nationalCode
     * @example '8075859741'
     * @link https://fa.wikipedia.org/wiki/%DA%A9%D8%A7%D8%B1%D8%AA_%D8%B4%D9%86%D8%A7%D8%B3%D8%A7%DB%8C%DB%8C_%D9%85%D9%84%DB%8C#%D8%AD%D8%B3%D8%A7%D8%A8_%DA%A9%D8%B1%D8%AF%D9%86_%DA%A9%D8%AF_%DA%A9%D9%86%D8%AA%D8%B1%D9%84
     * @return string
     */
    public static function nationalCode()
    {
        $area = self::createAreaCode();
        $core = self::createCoreCode();
        $control = self::createControlCode($area, $core);

        return sprintf("%03d%06d%01d", $area, $core, $control);
    }

    /**
     * This method generates a 3-digit valid area code to be used in nationalCode
     * @return int|string
     */
    private static function createAreaCode()
    {
        $area = "000";

        while ($area == "000") {
            $area = static::numerify("###");
        }

        return $area;
    }

    /**
     * This method randomly generates a 6-digit core code for nationalCode
     * @return string
     */
    private static function createCoreCode()
    {
        return static::numerify("######");
    }

    /**
     * This method uses the Iranian nationalCode validation algorithm to generate a valid 10-digit code
     * @param string $area
     * @param string $core
     * @link https://fa.wikipedia.org/wiki/%DA%A9%D8%A7%D8%B1%D8%AA_%D8%B4%D9%86%D8%A7%D8%B3%D8%A7%DB%8C%DB%8C_%D9%85%D9%84%DB%8C#%D8%AD%D8%B3%D8%A7%D8%A8_%DA%A9%D8%B1%D8%AF%D9%86_%DA%A9%D8%AF_%DA%A9%D9%86%D8%AA%D8%B1%D9%84
     * @return int
     */
    private static function createControlCode($area, $core)
    {
        $subNationalCodeString = $area . $core;

        $sum = 0;
        $count = 0;

        for ($i = 10; $i > 1; $i--) {
            $sum += $subNationalCodeString[$count] * ($i);
            $count++;
        }

        if (($sum % 11) < 2) {
            return $sum % 11;
        }
        return 11 - ($sum % 11);
    }
}
